/*
 * Decompiled with CFR 0.152.
 */
package com.ftw_and_co.happn.extension;

import com.ftw_and_co.happn.extension.StringExtensionsKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\u0007\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\r"}, d2={"camelRegex", "Lkotlin/text/Regex;", "getCamelRegex", "()Lkotlin/text/Regex;", "snakeOrKebabRegex", "getSnakeOrKebabRegex", "firstCharLowerCase", "", "firstCharUpperCase", "pascalToSnakeCase", "replaceDotWithSlash", "snakeToKebabCase", "toPascalCase", "core"})
@SourceDebugExtension(value={"SMAP\nStringExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringExtensions.kt\ncom/ftw_and_co/happn/extension/StringExtensionsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,48:1\n429#2:49\n502#2,5:50\n*S KotlinDebug\n*F\n+ 1 StringExtensions.kt\ncom/ftw_and_co/happn/extension/StringExtensionsKt\n*L\n18#1:49\n18#1:50,5\n*E\n"})
public final class StringExtensionsKt {
    @NotNull
    private static final Regex camelRegex = new Regex("(?<=[a-zA-Z0-9])[A-Z0-9]");
    @NotNull
    private static final Regex snakeOrKebabRegex = new Regex("(?<=([_\\- ]))([a-zA-Z]*)");

    @NotNull
    public static final Regex getCamelRegex() {
        return camelRegex;
    }

    @NotNull
    public static final Regex getSnakeOrKebabRegex() {
        return snakeOrKebabRegex;
    }

    @NotNull
    public static final String pascalToSnakeCase(@NotNull String $this$pascalToSnakeCase) {
        Intrinsics.checkNotNullParameter($this$pascalToSnakeCase, "<this>");
        String string = camelRegex.replace((CharSequence)$this$pascalToSnakeCase, pascalToSnakeCase.1.INSTANCE).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toPascalCase(@NotNull String $this$toPascalCase) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPascalCase, "<this>");
        String $this$filter$iv = snakeOrKebabRegex.replace((CharSequence)$this$toPascalCase, toPascalCase.1.INSTANCE);
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            char c = it;
            boolean bl2 = !((c == ' ' ? true : c == '_') ? true : c == '-');
            if (!bl2) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue(string, "filterTo(StringBuilder(), predicate).toString()");
        return StringExtensionsKt.firstCharUpperCase(string);
    }

    @NotNull
    public static final String snakeToKebabCase(@NotNull String $this$snakeToKebabCase) {
        Intrinsics.checkNotNullParameter($this$snakeToKebabCase, "<this>");
        return StringsKt.replace$default($this$snakeToKebabCase, "_", "-", false, 4, null);
    }

    @NotNull
    public static final String replaceDotWithSlash(@NotNull String $this$replaceDotWithSlash) {
        Intrinsics.checkNotNullParameter($this$replaceDotWithSlash, "<this>");
        return StringsKt.replace$default($this$replaceDotWithSlash, ".", "/", false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String firstCharUpperCase(@NotNull String $this$firstCharUpperCase) {
        String string;
        Intrinsics.checkNotNullParameter($this$firstCharUpperCase, "<this>");
        String string2 = $this$firstCharUpperCase;
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void firstChar;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)firstChar)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
                string3 = CharsKt.titlecase((char)firstChar, locale);
            } else {
                string3 = String.valueOf((char)firstChar);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String firstCharLowerCase(@NotNull String $this$firstCharLowerCase) {
        String string;
        Intrinsics.checkNotNullParameter($this$firstCharLowerCase, "<this>");
        String string2 = $this$firstCharLowerCase;
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void firstChar;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isUpperCase((char)firstChar)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
                string3 = CharsKt.lowercase((char)firstChar, locale);
            } else {
                string3 = String.valueOf((char)firstChar);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        return string;
    }
}

