//
//  UserInfosView.swift
//
//
//  Created by Nicolas Sabella on 15/07/2025.
//

import SwiftUI

import happnPolis
import happnUI

public struct UserInfosView: View {

	let viewData: UserInfosViewData

	public init(viewData: UserInfosViewData) {
		self.viewData = viewData
	}

	public var body: some View {
		VStack(spacing: SpacingToken.spacing0.size) {
			LabelWithIconView(
				token: LabelWithIconToken(
					style: .dark,
					size: .xxLarge(italic: true),
					alignment: .center,
					contraintMode: .hug
				),
				viewData: viewData.nameAndAgeViewData
			)
			.padding(.top, SpacingToken.spacing8.size)
			.accessibilityIdentifier(id: "nameAndAge", children: .contain)
			.frame(maxWidth: .infinity, alignment: .leading)

			SpacerView(height: SpacingToken.spacing4.size)

			if viewData.crossingInfosViewData != nil ||
				viewData.activityInfosViewData != nil ||
				viewData.relationshipInfosViewData != nil {
				HStack(spacing: SpacingToken.spacing12.size) {
					if let relationshipViewData = viewData.relationshipInfosViewData {
						LabelWithIconView(
							token: LabelWithIconToken(
								style: .colored(
									textColorToken: viewData.relationShipInfosTextColor ?? .weak,
									tintColorToken: viewData.relationShipInfosTintColor ?? .weak
								),
								size: .xxSmall,
								alignment: .left,
								contraintMode: .hug
							),
							viewData: relationshipViewData
						)
						.layoutPriority(2)
						.accessibilityIdentifier(id: "crossing", children: .contain)
					}

					if let crossingInfosViewData = viewData.crossingInfosViewData {
						LabelWithIconView(
							token: LabelWithIconToken(
								style: .colored(
									textColorToken: .weak,
									tintColorToken: .weak
								),
								size: .xxSmall,
								alignment: .left,
								contraintMode: .hug,
								lineBreakMode: .byTruncatingTail
							),
							viewData: crossingInfosViewData
						)
						.layoutPriority(1)
						.accessibilityIdentifier(id: "crossing", children: .contain)
					}

					if viewData.crossingInfosViewData == nil ||
						viewData.relationshipInfosViewData == nil,
					   let activityInfosViewData = viewData.activityInfosViewData {
						LabelWithIconView(
							token: LabelWithIconToken(
								style: .colored(
									textColorToken: .shopEssential,
									tintColorToken: .shopEssential
								),
								size: .xxSmall,
								alignment: .left,
								contraintMode: .hug,
								lineBreakMode: .byTruncatingTail
							),
							viewData: activityInfosViewData
						)
						.layoutPriority(0)
						.accessibilityIdentifier(id: "crossing", children: .contain)
					}

					Spacer()
				}
			}

			if viewData.expandableBannerViewData != nil ||
				viewData.bannerViewData != nil {

				SpacerView(height: SpacingToken.spacing12.size)

				if let expandableBannerViewData = viewData.expandableBannerViewData {
					ExpandableBannerView(
						token: ExpandableBannerToken(type: .opaque),
						viewData: expandableBannerViewData
					)
				} else if let bannerViewData = viewData.bannerViewData {
					BannerView(
						token: BannerToken(
							style: .colored(color: .inverseWeak),
							avatarIconToken: AvatarIconToken(
								size: .xxSmall,
								style: .dark
							),
							avatarSetToken: AvatarSetToken(
								size: .xxSmall,
								style: .light
							)
						),
						viewData: bannerViewData
					)
					.frame(
						maxWidth: .infinity,
						alignment: .leading
					)
				}
			}
		}
		.animation(.easeInOut, value: viewData.bannerViewData)
	}
}
