import Foundation

import happnPolis
import happnShops

extension CTAProfileDisplayViewData {
	public init(
		actionButtonConfigurationType: ActionButtonConfigurationType?,
		boostEnabled: Bool = false,
		boost: UserBoostDomainModel? = nil,
		boostBalance: Int = 0,
		flashnoteBalance: Int = 0,
		isPrioritaryLikeActivated: Bool = false,
		isReactOnContentEnabled: Bool = false
	) {
		let isBoostCreditRemaining = boostBalance > 0
		let isFlashNoteCreditRemaining = flashnoteBalance > 0
		let boostButtonState: BoostState?
		if boostEnabled {
			if let boost = boost {
				boostButtonState = boost.status == .running ? .running : (isBoostCreditRemaining ? .available : .default)
			} else {
				boostButtonState = isBoostCreditRemaining ? .available : .default
			}
		} else {
			boostButtonState = nil
		}

		switch actionButtonConfigurationType {
			case .me:
				self.init(
					isLikeButtonEnabled: false,
					isflashnoteButtonEnabled: false,
					isRejectButtonEnabled: false,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: isPrioritaryLikeActivated,
					boostButtonState: nil
				)

			case .likedMe:
				self.init(
					isLikeButtonEnabled: true,
					isflashnoteButtonEnabled: true,
					isRejectButtonEnabled: true,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: isPrioritaryLikeActivated,
					boostButtonState: boostButtonState
				)

			case .charmedMe:
				self.init(
					isLikeButtonEnabled: true,
					isflashnoteButtonEnabled: false,
					isRejectButtonEnabled: true,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: isPrioritaryLikeActivated,
					boostButtonState: boostButtonState
				)

			case .crushed:
				 self.init(
					isLikeButtonEnabled: false,
					isflashnoteButtonEnabled: false,
					isRejectButtonEnabled: false,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: isPrioritaryLikeActivated,
					boostButtonState: nil
				)

			case .alreadyCharmed:
				self.init(
					isLikeButtonEnabled: false,
					isflashnoteButtonEnabled: false,
					isRejectButtonEnabled: !isReactOnContentEnabled,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: isPrioritaryLikeActivated,
					boostButtonState: boostButtonState
				)

			case .alreadyReacted:
				self.init(
					isLikeButtonEnabled: false,
					isflashnoteButtonEnabled: true,
					isRejectButtonEnabled: !isReactOnContentEnabled,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: isPrioritaryLikeActivated,
					boostButtonState: boostButtonState
				)

			case .sponsored:
				self.init(
					isLikeButtonEnabled: true,
					isflashnoteButtonEnabled: false,
					isRejectButtonEnabled: true,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: false,
					boostButtonState: boostButtonState
				)

			case .sponsoredAlreadyReacted:
				self.init(
					isLikeButtonEnabled: false,
					isflashnoteButtonEnabled: false,
					isRejectButtonEnabled: false,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: false,
					boostButtonState: boostButtonState
				)

			case .ads:
				self.init(
					isLikeButtonEnabled: false,
					isflashnoteButtonEnabled: false,
					isRejectButtonEnabled: true,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: false,
					boostButtonState: nil
				)

			case .none:
				self.init(
					isLikeButtonEnabled: true,
					isflashnoteButtonEnabled: true,
					isRejectButtonEnabled: true,
					isFlashNoteCreditRemaining: isFlashNoteCreditRemaining,
					isPrioritaryLikeActivated: isPrioritaryLikeActivated,
					boostButtonState: boostButtonState
				)
		}
	}
}
