//
//  UserBadgeViewData.swift
//  
//
//  Created by Sunggweon Hyeong on 10/05/2023.
//

import happnPolis
import happnUsers

public struct UserBadgeViewData {

	public let badgeType: UserBadgeType
	public let bannerViewData: BannerViewData?

	public init(
		badgeType: UserBadgeType,
		meIsMale: Bool,
		otherIsMale: Bool,
		avatarSetIconViewTypes: [AvatarIconViewType] = [],
		message: String? = nil,
		isReactOnContentEnabled: Bool
	) {
		self.badgeType = badgeType
		self.bannerViewData = BannerViewData(
			badgeType: badgeType,
			meIsMale: meIsMale,
			otherIsMale: otherIsMale,
			avatarSetIconViewTypes: avatarSetIconViewTypes,
			message: message,
			isReactOnContentEnabled: isReactOnContentEnabled
		)
	}
}
