//
//  BannerViewData+Extension.swift
//
//
//  Created by Sunggweon Hyeong on 10/05/2023.
//

import Foundation
import SwiftUI
import XibLoc

import happnPolis
import happnUsers
import happnUtils

// swiftlint:disable cyclomatic_complexity function_body_length
extension BannerViewData {
	convenience init?(
		badgeType: UserBadgeType,
		meIsMale: Bool,
		otherIsMale: Bool,
		avatarSetIconViewTypes: [AvatarIconViewType] = [],
		message: String? = nil,
		isReactOnContentEnabled: Bool
	) {
		switch badgeType {
			case .sponsored:
				self.init(
					title: .text(L10n.sponsored),
					overridedBackgroundColor: .inverseWeak
				)

			case .likedMe:
				let title = isReactOnContentEnabled ? L10n.reactionReceivedText : L10n.reactionReceivedText2
				self.init(
					avatarIconViewData: AvatarIconViewData(type: .icon(IconAsset.heart), overridedTint: .cranberryDefault, overridedBackgroundColor: .backgroundToken(.inverse)),
					title: .text(title.applying(
						xibLocInfo: Str2StrXibLocInfo(
							genderMeIsMale: meIsMale,
							genderOtherIsMale: otherIsMale
						)
					))
				)

			case .charmedMe:
				self.init(
					avatarIconViewData: AvatarIconViewData(type: .icon(IconAsset.supercrush), overridedTint: .skyDefault, overridedBackgroundColor: .backgroundToken(.inverse)),
					title: .text(L10n.profileViewSupercrushReceived.applying(
						xibLocInfo: Str2StrXibLocInfo(
							genderMeIsMale: meIsMale,
							genderOtherIsMale: otherIsMale
						)
					)),
					message: message
				)

			case .comet:
				self.init(
					avatarSetViewData: AvatarSetViewData(
						avatarSetIconViewTypes.map { icon in
							AvatarIconViewData(
								type: icon,
								showBorder: true
							)
						}
					),
					title: .text(L10n.badgeRomaCompatibilityTitle),
					extendFrame: false
				)

			case .cometExplanation:
				self.init(
					avatarSetViewData: AvatarSetViewData(
						avatarSetIconViewTypes.map { icon in
							AvatarIconViewData(
								type: icon,
								showBorder: true
							)
						}
					),
					title: .text(L10n.badgeRomaCompatibilityTitle),
					message: message,
					extendFrame: true,
					animateText: true
				)

			case .crushed:
				self.init(
					leftIcon: .token(IconAsset.sparkle),
					title: .text(L10n.reactionAlreadyCrushText.applying(
						xibLocInfo: Str2StrXibLocInfo(
							genderMeIsMale: meIsMale,
							genderOtherIsMale: otherIsMale
						)
					))
				)

			case .alreadyCharmed:
				self.init(
					avatarIconViewData: AvatarIconViewData(type: .icon(IconAsset.supercrush), overridedTint: .skyDefault, overridedBackgroundColor: .backgroundToken(.inverse)),
					title: .text(L10n.profileViewSupercrushSent.applying(
						xibLocInfo: Str2StrXibLocInfo(
							genderMeIsMale: meIsMale,
							genderOtherIsMale: otherIsMale
						)
					))
				)

			case .alreadyReacted:
				self.init(
					avatarIconViewData: AvatarIconViewData(type: .icon(IconAsset.heart), overridedTint: .cranberryDefault, overridedBackgroundColor: .backgroundToken(.inverse)),
					title: .text(L10n.profileViewLikeSent.applying(
						xibLocInfo: Str2StrXibLocInfo(
							genderMeIsMale: meIsMale,
							genderOtherIsMale: otherIsMale
						)
					))
				)

			case .crossedRegularly:
				self.init(
					leftIcon: .token(IconAsset.happn),
					title: .text(L10n.profileBadgesCrossedPathsOften)
				)

			case .crossedOnce:
				self.init(
					leftIcon: .token(IconAsset.happn),
					title: .text(L10n.profileBadgesCrossedForTheFirstTime.applying(
						xibLocInfo: Str2StrXibLocInfo(
							genderMeIsMale: meIsMale,
							genderOtherIsMale: otherIsMale
						)
					))
				)

			case .commonTraits(let count):
				self.init(
					leftIcon: .token(IconAsset.common),
					title: .text(L10n.profileBadgesCommonPoints.applying(
						xibLocInfo: Str2StrXibLocInfo(
							pluralValue: NumberAndFormat(count)
						)
					))
				)

			case .trait(let trait):
				switch trait {
					case .cookingMaster:
						self.init(
							leftIcon: .token(IconAsset.cook),
							title: .text(L10n.profileBadgesCookingChoice4.applying(
								xibLocInfo: Str2StrXibLocInfo(
									genderMeIsMale: meIsMale,
									genderOtherIsMale: otherIsMale
								)
							))
						)

					case .sportMaster:
						self.init(
							leftIcon: .token(IconAsset.sport),
							title: .text(L10n.profileBadgesSportChoice4.applying(
								xibLocInfo: Str2StrXibLocInfo(
									genderMeIsMale: meIsMale,
									genderOtherIsMale: otherIsMale
								)
							))
						)

					case .partyMaster:
						self.init(
							leftIcon: .token(IconAsset.party),
							title: .text(L10n.profileBadgesPartyChoice3.applying(
								xibLocInfo: Str2StrXibLocInfo(
									genderMeIsMale: meIsMale,
									genderOtherIsMale: otherIsMale
								)
							))
						)

					case .travel:
						self.init(
							leftIcon: .token(IconAsset.airplane),
							title: .text(L10n.profileBadgesTravel.applying(
								xibLocInfo: Str2StrXibLocInfo(
									genderMeIsMale: meIsMale,
									genderOtherIsMale: otherIsMale
								)
							))
						)

					default:
						self.init()
				}

			case .vieweeTourist(let city):
				self.init(
					leftIcon: .token(IconAsset.airplane),
					title: city != nil ? .text(L10n.profileBadgesVieweeTourist.applying(
						xibLocInfo: Str2StrXibLocInfo(
							replacement: city,
							genderOtherIsMale: otherIsMale
						)
					)) : nil
				)

			case .vieweeAndViewerTourists(let city):
				self.init(
					leftIcon: .token(IconAsset.airplane),
					title: city != nil ? .text(L10n.profileBadgesVieweeAndViewerTourists.applying(
						xibLocInfo: Str2StrXibLocInfo(
							replacement: city,
							genderOtherIsMale: otherIsMale
						)
					)) : nil
				)

			case .sameResidenceAndTourists(let city):
				self.init(
					leftIcon: .token(IconAsset.home),
					title: .text(L10n.profileBadgesSameCityOfResidenceAndTourists.applying(
						xibLocInfo: Str2StrXibLocInfo(
							replacement: city,
							genderOtherIsMale: otherIsMale
						)
					))
				)

			case .sameResidence(let city):
				self.init(
					leftIcon: .token(IconAsset.home),
					title: .text(L10n.profileBadgesSameCityOfResidence.applying(
						xibLocInfo: Str2StrXibLocInfo(
							replacement: city,
							genderOtherIsMale: otherIsMale
						)
					))
				)

			case .teasers, .activity, .relationship:
				self.init()
		}
	}
}
