//
//  UserProfileViewType.swift
//  happnProfileUtils
//
//  Created by Sunggweon Hyeong on 25/06/2025.
//

import Foundation

import happnPolis
import happnTraits
import happnUsers

public enum UserProfileViewType: Equatable {
	case blockReport(viewData: ButtonViewData)
	case communSpot(viewData: CardSpotViewData)
	case crossing(viewData: CardActionViewData)
	case description(viewData: CardTextViewData)
	case photo(viewData: CardUserStateToken, id: String)
	case pictureContentCarousel(viewData: [PictureContentViewDataState], shouldDisplayOnboarding: Bool)
	case relationshipUserInfosAndTraits(viewData: CardMultiSelectionViewData)
	case spacer(height: SpacingToken)
	case spots(viewData: CardPillsViewData)
	case trait(viewData: CardPillsViewData)
	case traitMultiChoice(viewData: UserTraitMultiChoiceViewData)
	case userInfos(viewData: UserInfosViewData)
	case userInputAnswer(viewData: UserTraitUserInputAnswerViewData)

	public func isSameCase(as other: UserProfileViewType) -> Bool {
		switch (self, other) {
			case (.blockReport, .blockReport): return true
			case (.communSpot, .communSpot): return true
			case (.crossing, .crossing): return true
			case (.description, .description): return true
			case (.photo, .photo): return true
			case (.pictureContentCarousel, .pictureContentCarousel): return true
			case (.relationshipUserInfosAndTraits, .relationshipUserInfosAndTraits): return true
			case (.spacer, .spacer): return true
			case (.spots, .spots): return true
			case (.trait, .trait): return true
			case (.traitMultiChoice, .traitMultiChoice): return true
			case (.userInfos, .userInfos): return true
			case (.userInputAnswer, .userInputAnswer): return true
			default: return false
		}
	}

	public var isPhoto: Bool {
		switch self {
			case .photo, .pictureContentCarousel:
				return true

			default:
				return false
		}
	}

	public var isReaction: Bool {
		switch self {
			case .blockReport, .spacer, .userInfos:
				return false

			default:
				return true
		}
	}

	public var contentId: String? {
		switch self {
			case let .photo(_, id):
				return id

			case let .userInputAnswer(viewData):
				return viewData.traitId

			default:
				return nil
		}
	}

	public var contentURL: String? {
		switch self {
			case let .photo(viewData, _):
				return viewData.url?.absoluteString

			default:
				return nil
		}
	}

	public var containerType: ContainerType {
		switch self {
			case .communSpot:
				return .spots

			case .crossing:
				return .map

			case .description:
				return .description

			case .photo, .pictureContentCarousel:
				return .photo

			case .relationshipUserInfosAndTraits:
				return .traits

			case .spots:
				return .spots

			case .trait:
				return .traits

			case .traitMultiChoice:
				return .hobbies

			case .userInputAnswer:
				return .teasers

			case .spacer, .blockReport, .userInfos:
				return .all
		}
	}
}
