//
//  PillViewData+Timeline.swift
//  
//
//  Created by Nicolas Sabella on 11/05/2023.
//

import Foundation

import XibLoc

import happnPolis
import happnUtils

// MARK: - User Infos
extension PillViewData {
	public init(
		city: String,
		country: String?,
		isTheSameCity: Bool = false
	) {

		var residence: String = city
		if let country, !country.isEmpty {
			residence += ", \(country)"
		}
		self.init(
			text: residence,
			leftIcon: .localIcon(IconAsset.home),
			state: isTheSameCity ? .isActive : .default
		)
	}

	public init?(
		job: String?,
		workplace: String?
	) {

		let icon: PillIconType = .localIcon(IconAsset.briefcase)

		if let job = job, let workplace = workplace, !job.isEmpty, !workplace.isEmpty {
			self.init(text: "\(job), \(workplace)", leftIcon: icon)
		} else if let job = job, !job.isEmpty {
			self.init(text: job, leftIcon: icon)
		} else if let workplace = workplace, !workplace.isEmpty {
			self.init(text: workplace, leftIcon: icon)
		} else {
			return nil
		}
	}

	public init(
		school: String
	) {

		self.init(text: school, leftIcon: .localIcon(IconAsset.school))
	}

	public init(
		distance: String
	) {
		self.init(text: distance, leftIcon: .localIcon(IconAsset.location))
	}

	public init?(
		activityDate: Date,
		userMeIsMale: Bool
	) {
		var stateString = ""
		let state = abs(activityDate.toLocalTime().timeIntervalSinceNow).getConnectionVintageString()

		switch state {
			case .online:
				stateString = L10n.chatOnlineStatus

			case .minutesAgo(let minutes):
				stateString = L10n.chatActiveNMinAgoBold.applying(
					xibLocInfo: Str2StrXibLocInfo(numberReplacement: NumberAndFormat(minutes))
				)

			case .hoursAgo(let hour):
				stateString = L10n.chatActiveNHourAgoBold.applying(
					xibLocInfo: Str2StrXibLocInfo(pluralValue: NumberAndFormat(hour))
				).applying(xibLocInfo: Str2StrXibLocInfo(genderOtherIsMale: userMeIsMale))

			case .today:
				stateString = L10n.chatActiveTodayBold

			case .yesterday:
				stateString = L10n.chatActiveYesterdayBold

			case .none:
				return nil
		}

		let finalStr = stateString.applying(xibLocInfo: Str2StrXibLocInfo(genderOtherIsMale: userMeIsMale))

		self.init(text: finalStr, leftIcon: .localIcon(IconAsset.clock))
	}
}

// MARK: - Traits
extension PillViewData {
	public init(
		text: String,
		icon: PillIconType? = nil,
		isCommonAnswer: Bool
	) {
		self.init(text: text, leftIcon: icon, state: PillState(isActive: isCommonAnswer))
	}

	public init(
		genderAlias: String
	) {
		self.init(
			text: genderAlias,
			leftIcon: .localIcon(IconAsset.gender)
		)
	}
}
