//
//  LabelWithIconViewData+Extension.swift.swift
//
//
//  Created by Sunggweon Hyeong on 03/05/2023.
//

import Foundation

import XibLoc

import happnPolis
import happnUtils

extension LabelWithIconViewData {
	public init(nameAndAge: String, isCertified: Bool) {
		self.init(
			text: nameAndAge,
			numberOfLines: 1,
			rightIconViewData: isCertified ? ImageViewComponentViewData(
				imageContentModeToken: .fitContainer,
				source: .token(SymbolAssetToken.verify),
				imageToken: .icon(
					colorToken: ImageComponentIconColorToken(
						PolisColor.IconToken.inverseWeaker,
						PolisColor.IconToken.skyBolder,
						PolisColor.IconToken.inverseWeaker
					)
				)
			) : nil
		)
	}
}
