//
//  ShouldShowContentOnCarouselOnboardingUseCase.swift
//  happnProfileUtils
//
//  Created by Safia Chmiti on 30/12/2025.
//

import Foundation

import happnConfiguration

public protocol ShouldShowContentOnCarouselOnboardingUseCaseProtocol {
	var current: Bool { get }
}

public class ShouldShowContentOnCarouselOnboardingUseCase: ShouldShowContentOnCarouselOnboardingUseCaseProtocol {

	// MARK: - Private properties
	private let timelineProfilesCountUseCase: TimelineProfilesCountUseCaseProtocol

	// MARK: - public properties
	public var current: Bool {
		return UserDefaults.shouldDisplayContentOnCarouselOnboarding && !UserDefaults.hasInteractedWithCarousel && timelineProfilesCountUseCase.current > 0
	}

	// MARK: - Initialization
	public init(timelineProfilesCountUseCase: TimelineProfilesCountUseCaseProtocol) {
		self.timelineProfilesCountUseCase = timelineProfilesCountUseCase
	}
}
