//
//  TimelineProfilesCountStateRepository.swift
//  happnProfileUtils
//
//  Created by Luc-Olivier Merson on 31/12/2025.
//

import Combine

public protocol TimelineProfilesCountStateRepositoryProtocol {
	var current: Int { get }
	func increment()
}

class TimelineProfilesCountStateRepository: TimelineProfilesCountStateRepositoryProtocol {

	// MARK: - Private properties
	private let state: CurrentValueSubject<Int, Never> = CurrentValueSubject(0)

	// MARK: - Public computed properties
	var current: Int {
		return state.value
	}

	// MARK: - Pubic methods
	func increment() {
		state.value += 1
	}
}
