// swift-tools-version:5.5
// The swift-tools-version declares the minimum version of Swift required to build this package.

import PackageDescription

let package = Package(
	name: "happnProfileUtils",
	defaultLocalization: "en",
	platforms: [
		.iOS("17.0")
	],
	products: [
		// Products define the executables and libraries a package produces, and make them visible to other packages.
		.library(
			name: "happnProfileUtils",
			targets: ["happnProfileUtils"]),
		.library(
            name: "happnProfileUtilsMock",
            targets: ["happnProfileUtilsMock"])
	],
	dependencies: [
		.package(path: "../happnAds"),
		.package(path: "../happnConfiguration"),
		.package(path: "../happnConstants"),
		.package(path: "../happnFlashnote"),
		.package(path: "../happnLocation"),
		.package(path: "../happnLogger"),
		.package(path: "../happnMap"),
		.package(path: "../happnNavigation"),
		.package(path: "../happnNetworking"),
		.package(path: "../happnPolis"),
		.package(path: "../happnShops"),
		.package(path: "../happnSmartIncentive"),
		.package(path: "../happnSpots"),
		.package(path: "../happnTracking"),
		.package(path: "../happnUI"),
		.package(path: "../happnUsers"),
		.package(path: "../happnUtils"),
		.package(path: "../happnViewDataUtils"),
		.package(url: "https://github.com/Quick/Nimble", .upToNextMajor(from: "12.0.0")),
		.package(url: "https://github.com/Quick/Quick", .upToNextMajor(from: "7.0.0")),
		.package(url: "https://github.com/ReactiveX/RxSwift", .upToNextMinor(from: "6.6.0")),
		.package(url: "https://github.com/Swinject/Swinject", from: "2.7.1"),
		.package(url: "https://github.com/Swinject/SwinjectAutoregistration", from: "2.7.0"),
	],
	targets: [
		// Targets are the basic building blocks of a package. A target can define a module or a test suite.
		// Targets can depend on other targets in this package, and on products in packages this package depends on.
		.target(
			name: "happnProfileUtils",
			dependencies: [
				"happnAds",
				"happnConfiguration",
				"happnConstants",
				"happnFlashnote",
				"happnLocation",
				"happnLogger",
				"happnMap",
				"happnNavigation",
				"happnNetworking",
				"happnPolis",
				"happnShops",
				"happnSmartIncentive",
				"happnSpots",
				"happnTracking",
				"happnUI",
				"happnUsers",
				"happnUtils",
				"happnViewDataUtils",
				"RxSwift",
				.product(name: "RxCocoa", package: "RxSwift"),
				"Swinject",
				"SwinjectAutoregistration"
			]),
		.target(
            name: "happnProfileUtilsMock",
            dependencies: [
                "happnProfileUtils"
            ]),
		.testTarget(
			name: "happnProfileUtilsTests",
			dependencies: [
				"happnProfileUtils",
				"happnProfileUtilsMock",
				"Quick",
				"Nimble",
				"happnUsers",
				.product(name: "happnUsersMock", package: "happnUsers"),
				.product(name: "RxTest", package: "RxSwift"),
				.product(name: "RxBlocking", package: "RxSwift")
			]),
	]
)
