//
//  TimelineProfilesCountUseCase.swift
//  happnProfileUtils
//
//  Created by Luc-Olivier Merson on 31/12/2025.
//

public protocol TimelineProfilesCountUseCaseProtocol {
	var current: Int { get }
	func increment()
}

class TimelineProfilesCountUseCase: TimelineProfilesCountUseCaseProtocol {

	// MARK: - Private properties
	private let stateRepository: TimelineProfilesCountStateRepositoryProtocol

	public init(stateRepository: TimelineProfilesCountStateRepositoryProtocol) {
		self.stateRepository = stateRepository
	}

	// MARK: - Public computed properties
	var current: Int {
		return stateRepository.current
	}

	// MARK: - Pubic methods
	func increment() {
		stateRepository.increment()
	}
}
